    

    <?php $__env->startSection('title', 'Data Jadwal Shift'); ?>

    <?php $__env->startSection('content'); ?>

        <div class="d-flex justify-content-between align-items-center mb-4">
            <div>
                <h4 class="fw-bold mb-1">Data Jadwal Shift</h4>
                <small class="text-muted">Manajemen jadwal shift</small>
            </div>

            <button class="btn btn-primary btn-sm d-flex align-items-center" data-bs-toggle="modal"
                data-bs-target="#tambahJadwal">
                <i class="fas fa-plus me-2"></i>Tambah Data
            </button>
        </div>

        <div class="card shadow-sm border-0">
            <div class="card-body">

                <table class="table table-hover align-middle">
                    <thead class="table-light">
                        <tr>
                            <th>#</th>
                            <th>Departemen</th>
                            <th>Shift</th>
                            <th>Tanggal Mulai</th>
                            <th>Tanggal Selesai</th>
                            <th>LStatus</th>
                            <th class="text-center">Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $jadwalShift; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($loop->iteration); ?></td>
                                <td><?php echo e($item->departemen->nama); ?></td>
                                <td>
                                    <?php echo e($item->shift->kode); ?>

                                    <small class="text-muted d-block">
                                        <?php echo e(substr($item->shift->jam_masuk, 0, 5)); ?>

                                        -
                                        <?php echo e(substr($item->shift->jam_pulang, 0, 5)); ?>

                                    </small>
                                </td>

                                
                                <td><?php echo e($item->tanggal_mulai ?? '-'); ?></td>
                                <td><?php echo e($item->tanggal_selesai ?? '-'); ?></td>
                                <td><?php echo e($item->is_active); ?></td>

                                <td class="text-center">
                                    <button data-bs-target="#ubahJadwal<?php echo e($item->id); ?>" data-bs-toggle="modal"
                                        class="btn btn-sm btn-warning">
                                        <i class="fas fa-edit"></i>
                                    </button>
                                    <button class="btn btn-sm btn-danger" data-bs-toggle="modal"
                                        data-bs-target="#hapusJadwal<?php echo e($item->id); ?>">
                                        <i class="fas fa-trash"></i>
                                    </button>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>

            </div>
            <?php $__currentLoopData = $shift; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php echo $__env->make('admin.jadwal-shift.edit', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
        <?php echo $__env->make('admin.jadwal-shift.create', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


    <?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\DAVA\Documents\FILE_SEKOLAH\WEB XII\absensi-hotel - Copy\resources\views/admin/jadwal-shift/index.blade.php ENDPATH**/ ?>